#Cuadro IX.8
#Contrastes de homogeneidad no paramtricos para K muestras independientes. Prueba de Kruskal-Wallis.

##############################################
#Seccin modificable por el usuario
##############################################

#Lectura de datos.
datos<-read.csv2("Cuadro IX.7.V.csv",header=TRUE,encoding="latin1")

#Seleccin variable dependiente.
#varInteres<-c("Nitrito")
varInteres<-c("Nitrato")
#varInteres<-c("Amonio")

#Variable que corresponde al factor.
varFactor<-c("Lago")
#varFactor<-c("Mes")

##Variables de seleccin. 
#Los elementos de las listas varSeleccion pueden modificarse en funcin de nuestros intereses.
#Pueden escogerse hasta dos grupos en cada variable de seleccin, en un nmero igual o inferior al n total de grupos - 1
#varSeleccion1<-list(c("Lago","Correo","Tarapoto"))
varSeleccion1<-NULL
varSeleccion2<-list(c("Mes","Febrero"))
#varSeleccion2<-NULL

#Archivo de salida.
ArchivodeSalida<-"Salida Cuadro IX.8.txt"

###############################################
#Seccin que realiza el procedimiento
###############################################

#Paquetes
require(stats)

##Organizacin de los datos.
datos1<-na.omit(datos)
valores<-(datos1[,varInteres])
factores<-(datos1[,varFactor])

#Selecciones
if (length(varSeleccion1)!=0){
 w1<-data.frame(row.names=1:dim(datos1)[1])
 varBin1<-as.character()
 for (i in 1:length(varSeleccion1)){
   nom1<-varSeleccion1[[i]][1]
   x1<-factor(datos1[,nom1])
   if (length(varSeleccion1[[i]])>1){
      sufijo1<-paste(varSeleccion1[[i]][2:3],collapse="_")
      nom1<-paste(nom1,".",sufijo1,sep="")
      x11<-factor(ifelse(x1 %in% varSeleccion1[[i]][2:3],as.character(x1),NA))
      x11<-data.frame(factor(x11))
   }else{
      x11<-x1
      x11<-data.frame(x1)
   }
   names(x11)<-nom1
   varBin1<-c(varBin1,nom1)
   w1<-data.frame(w1,x11)
 }
}

if (length(varSeleccion2)!=0){
 w2<-data.frame(row.names=1:dim(datos1)[1])
 varBin2<-as.character()
 for (i in 1:length(varSeleccion2)){
   nom2<-varSeleccion2[[i]][1]
   x2<-factor(datos1[,nom2])
   if (length(varSeleccion2[[i]])>1){
      sufijo2<-paste(varSeleccion2[[i]][2:3],collapse="_")
      nom2<-paste(nom2,".",sufijo2,sep="")
      x12<-factor(ifelse(x2 %in% varSeleccion2[[i]][2:3],as.character(x2),NA))
      x12<-data.frame(factor(x12))
   }else{
      x12<-x2
      x12<-data.frame(x2)
   }
   names(x12)<-nom2
   varBin2<-c(varBin2,nom2)
   w2<-data.frame(w2,x12)
 }
}

if ((length(varSeleccion1)!=0)&(length(varSeleccion2)!=0)) seleccion<-data.frame(w1,w2)
if ((length(varSeleccion1)!=0)&(length(varSeleccion2)==0)) seleccion<-data.frame(w1)
if ((length(varSeleccion1)==0)&(length(varSeleccion2)!=0)) seleccion<-data.frame(w2)
if ((length(varSeleccion1)==0)&(length(varSeleccion2)==0)) seleccion<-NULL

#Preparacin de los conjuntos de datos para el anlisis
if (length(seleccion)==0) datos2<-data.frame(factores,valores)
if (length(seleccion)!=0) datos2<-data.frame(seleccion,factores,valores)
datos2<-na.omit(datos2)

#Prueba de Kruskal-Wallis.
Kruskal.Wallis<-kruskal.test(datos2$valores,datos2$factores)

###############################################
#Seccin que muestra los resultados
###############################################

Resultados<-list(Kruskal.Wallis)

if(!is.null(ArchivodeSalida)){
 sink(ArchivodeSalida)
 print(Resultados)
 sink()
}
